Attribute VB_Name = "Cap_Common"
Option Explicit

Private ma_DefaultConfigScreenName() As String
Private ma_DefaultConfigFieldName() As String
Private ma_DefaultConfigCode() As String
Private ma_DefaultConfigDesc() As String

Private Declare Function GetDefaultPrinter Lib "winspool.drv" Alias "GetDefaultPrinterA" (ByVal pszBuffer As String, pcchBuffer As Long) As Long

Global gl_LocalID As Long
Global go_Trace As Trace

Public Function AddToTransfertLog(ByVal ao_Armdb As Object, ByVal as_UID As String, ByVal as_ID As String, ByVal as_TypeTransfert As String, ByVal as_Source As String, ByVal as_Destination As String, ByVal as_Request As String, ByVal ae_Result As Boolean, ByVal as_ErrMsg As String) As Boolean
Dim ls_LogRequest As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:AddToTransfertLog", "as_ID=" & as_ID & ",as_TypeTransfert=" & as_TypeTransfert & ", as_Destination=" & as_Destination & ", as_Source=" & as_Source & ", as_Request=" & as_Request & "ae_Result=" & ae_Result & "as_ErrMsg=" & as_ErrMsg
    #End If

    ls_LogRequest = "INSERT INTO Cap_Transfert_Log (ID, Login_Name, Type, Source, Destination, Z_Creation, Request, Result, ErrMsg)" & vbCrLf & _
                    "  VALUES (" & as_ID & ", " & FormatSqlStringParameter(as_UID) & _
                    ", " & FormatSqlStringParameter(as_TypeTransfert) & ", " & FormatSqlStringParameter(as_Source) & _
                    ", " & FormatSqlStringParameter(as_Destination) & ", GetDate()," & vbCrLf & _
                    FormatSqlStringParameter(as_Request) & ", " & IIf(ae_Result, "'S'", "'F'") & _
                    ", " & FormatSqlStringParameter(as_ErrMsg) & ")"
    
    If ao_Armdb.ExecuteSQL(ls_LogRequest) = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Cap_Common:AddToTransfertLog", "Request=", ls_LogRequest
        GoTo Trace_End
    End If
    
    AddToTransfertLog = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:AddToTransfertLog", "Result=" & AddToTransfertLog
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:AddToTransfertLog"
    CapMouseOn

End Function

Public Function GetTransfertID(ByRef ao_Armdb As Object, ByVal as_UID As String, ByVal as_TypeTransfert As String) As String
Dim ls_Request As String
Dim lc_ID As Long

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:GetTransfertID", "as_TypeTransfert=" & as_TypeTransfert
    #End If
    
    ls_Request = "SELECT isNull(MAX(ID) + 1, 1)" & vbCrLf & _
                    "FROM Cap_Transfert_Log" & vbCrLf & _
                    "WHERE Login_Name = " & FormatSqlStringParameter(as_UID) & " AND Type = " & FormatSqlStringParameter(as_TypeTransfert)
    lc_ID = ao_Armdb.OpenSQL(ls_Request)
    If lc_ID = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Cap_Common:GetTransfertID", "Request=", ls_Request
        GoTo Trace_End
    End If
    
    GetTransfertID = ao_Armdb.GetFields(lc_ID, 0)

Trace_End:
    Call ao_Armdb.Close(lc_ID)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:GetTransfertID", "Result=" & GetTransfertID
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    Call ao_Armdb.Close(lc_ID)
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:GetTransfertID"
    CapMouseOn

End Function

Public Function Update_ProjectRep(ByRef ao_Armdb As Object, ByVal as_SP_Capkey As String, ByVal as_SR_Code As String, ByVal as_OldRR_Code As String, ByVal as_NewRR_Code, ByRef as_Result As String) As Boolean
Dim ls_Request As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:Update_ProjectRep", "as_SP_CapKey=" & as_SP_Capkey, "as_SR_Code=" & as_SR_Code, "as_OldRR_Code=" & as_OldRR_Code, "as_NewRR_Code=" & as_NewRR_Code
    #End If
    CapMouseOff
    
    Update_ProjectRep = False
    
    ls_Request = "exec Cap_ProjectRep_Upd " & FormatSqlStringParameter(as_SP_Capkey) & "," & FormatSqlStringParameter(as_SR_Code) & "," & FormatSqlStringParameter(as_OldRR_Code) & "," & FormatSqlStringParameter(as_NewRR_Code) & ",'Y','N', NULL , '','',0,0"
    
    Update_ProjectRep = ASC_RecordExec(ao_Armdb, ls_Request, as_Result)
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:Update_ProjectRep", "Result=" & Update_ProjectRep, "as_Result=" & as_Result
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:Update_ProjectRep"
    CapMouseOn
End Function


' TASK 298.2
Public Function DeleteConfirmation(ByRef ao_Armdb As Object, ByVal as_LanguageCode As String, Optional al_msgID As Long = 939, Optional as_MsgDesc As String = "#Do you really want to delete this record ?") As Boolean
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:DeleteConfirmation"
    #End If
    
    DeleteConfirmation = False
    
    If ASC_SendMessage(ao_Armdb, as_LanguageCode, al_msgID, as_MsgDesc, , vbYesNo) = vbNo Then GoTo Trace_End
    
    DeleteConfirmation = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:DeleteConfirmation", "Result=" & DeleteConfirmation
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:DeleteConfirmation"
    CapMouseOn
End Function

Public Function ZipSearch_Ex(ByRef ao_Armdb As Object, ByVal ac_Zip As Long, ByVal as_ZipCode As String) As Long
Dim lc_Zip As Long

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:ZipSearch_Ex", "ac_Zip=" & ac_Zip & ", as_ZipCode=" & as_ZipCode
    #End If
    CapMouseOff
     
    If GetNumericPart(as_ZipCode) = -1 Then
        lc_Zip = ZipSearch_Str(ao_Armdb, ac_Zip, as_ZipCode)
    Else
        lc_Zip = ZipSearch_Num(ao_Armdb, ac_Zip, as_ZipCode)
    End If
    
    ZipSearch_Ex = lc_Zip
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:ZipSearch_Ex", "Result=" & ZipSearch_Ex
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ZipSearch_Ex = ac_Zip
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:ZipSearch_Ex"
    CapMouseOn
End Function

Public Function ZipSearch_Str(ByRef ao_Armdb As Object, ByVal ac_Zip As Long, ByVal as_ZipCode As String) As Long
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:ZipSearch_Str", "ac_Zip=" & ac_Zip & ", as_ZipCode=" & as_ZipCode
    #End If
    CapMouseOff
    
    ac_Zip = ao_Armdb.Filter(ac_Zip, "ZIP_MIN", "<=", as_ZipCode, , True)
    ac_Zip = ao_Armdb.Filter(ac_Zip, "ZIP_MAX", ">=", as_ZipCode, , True)
    
    ZipSearch_Str = ac_Zip
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:ZipSearch_Str", "Result=" & ZipSearch_Str
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ZipSearch_Str = ac_Zip
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:ZipSearch_Str"
    CapMouseOn
End Function

Public Function ZipSearch_Num(ByRef ao_Armdb As Object, ByVal ac_Zip As Long, ByVal as_ZipCode As String) As Long
Dim ll_Index As Long, ll_Count As Long, ls_ZipCodeID As String
Dim ll_ZipMin As Long, ll_ZipMax As Long, ll_NumZip As Long
Dim lc_Zip As Long
Dim ls_ZipStr As String
Dim ls_ZipMin As String, ls_ZipMax As String
Dim ls_ZipMinStr As String, ls_ZipMaxStr As String
Dim ll_RepFound As Long

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:ZipSearch_Num"
    #End If
    CapMouseOff
    
    ll_NumZip = GetNumericPart(as_ZipCode)
    
    ' We must limits first the zip code list to the string part of the zip code entered
    ls_ZipStr = UCase(GetStringPart(as_ZipCode))
    ac_Zip = ao_Armdb.Filter(ac_Zip, "ZIP_MIN", "begin", ls_ZipStr, , True)
    ll_Count = ao_Armdb.RowCount(ac_Zip) - 1
    For ll_Index = 0 To ll_Count
        ls_ZipMin = ao_Armdb.GetFields(ac_Zip, "ZIP_MIN")
        
        ls_ZipMax = ao_Armdb.GetFields(ac_Zip, "ZIP_MAX")
        ll_ZipMin = GetNumericPart(ls_ZipMin)
        ll_ZipMax = GetNumericPart(ls_ZipMax)
        ls_ZipMinStr = UCase(GetStringPart(ls_ZipMin))
        ls_ZipMaxStr = UCase(GetStringPart(ls_ZipMax))
        
        If (ll_NumZip >= ll_ZipMin) And (ll_NumZip <= ll_ZipMax) And (ls_ZipStr >= ls_ZipMinStr) And (ls_ZipStr <= ls_ZipMaxStr) Then
            ' It's the good one !
            ls_ZipCodeID = ao_Armdb.GetFields(ac_Zip, "Zip_Code")
            ll_RepFound = ll_RepFound + 1
        End If
        ao_Armdb.Next (ac_Zip)
    Next
      
    If ll_RepFound = 1 Then
        lc_Zip = ao_Armdb.Filter(ac_Zip, "Zip_Code", "=", ls_ZipCodeID, , True)
    Else
        lc_Zip = 0
        Call ao_Armdb.Close(ac_Zip)
    End If
    ZipSearch_Num = lc_Zip

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:ZipSearch_Num", "Result=" & ZipSearch_Num
    #End If
    CapMouseOn
    Exit Function

Trace_Err:
    Call ao_Armdb.Close(lc_Zip)
    Call ao_Armdb.Close(ac_Zip)
    ZipSearch_Num = 0
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:ZipSearch_Num"
   CapMouseOn
End Function

Public Function TestVersion(ByRef ao_Armdb As Object) As Boolean
Dim ll_Cursor As Long
Dim ls_Request As String
Dim VMaj As Integer
Dim VMin As Integer
Dim VRev As Integer
Dim Message As Boolean

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:TestVersion"
    #End If
    
    Message = False
    
    'TODO: test si la connexion a dj t ralise
    
    ls_Request = "exec s0_update_sel2 '" & "captureonline" & "'"
    ll_Cursor = ao_Armdb.OpenSQL(ls_Request, -1)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Cap_Common:TestVersion", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    VMaj = Val(ao_Armdb.GetFields(ll_Cursor, "major"))
    VMin = Val(ao_Armdb.GetFields(ll_Cursor, "minor"))
    VRev = Val(ao_Armdb.GetFields(ll_Cursor, "revision"))
    
    'Si version exe infrieure
    If VMaj > App.Major Then
        Message = True
    Else
        'Si version exe infrieure
        If VMin > App.Minor Then
            Message = True
        Else
            'Si version exe infrieure
            If VRev > App.Revision Then
                Message = True
            End If
        End If
    End If
    
    If Message Then
        Call ASC_SendMessage(ao_Armdb, "E", 940, "#This version of capture is out of date. Contact IT team")
    End If
    
    TestVersion = Not Message

Trace_End:
    ao_Armdb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:TestVersion", "Result=" & TestVersion
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ao_Armdb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:TestVersion"
    CapMouseOn
End Function

Public Function Delete_ProjectRep(ByRef ao_Armdb As Object, ByVal as_SP_Capkey As String, ByVal as_SR_Code As String, ByVal as_RR_Code As String, ByRef as_Result As String) As Boolean
Dim ls_Request As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:Delete_ProjectRep", "as_SP_Capkey=" & as_SP_Capkey, "as_SR_Code=" & as_SR_Code, "as_RR_Code=" & as_RR_Code
    #End If
    CapMouseOff

    Delete_ProjectRep = False

    ls_Request = "exec Cap_ProjectRep_Del" & FormatSqlStringParameter(as_SP_Capkey) & "," & FormatSqlStringParameter(as_SR_Code) & "," & FormatSqlStringParameter(as_RR_Code)
    Delete_ProjectRep = ASC_RecordExec(ao_Armdb, ls_Request, as_Result)
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:Delete_ProjectRep", "Result=" & Delete_ProjectRep, "as_Result=" & as_Result
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:Delete_ProjectRep"
    CapMouseOn
End Function

Public Sub Init_UserInfo(ByRef ao_Armdb As Object, as_UID As String)
Dim ll_Cursor As Long
Dim ls_Request As String
Dim li_DefaultConfigNumber As Integer

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:Init_User", "as_UID=" & as_UID
    #End If
    
    ls_Request = "select S.spoken_Language, DSI.CT_Code FROM Cap_DefaultValue_SecurityIdentity DSI, Security_Identity S WHERE DSI.Login_Name = '" & as_UID & "' AND S.Login_Name = DSI.Login_Name"
    ll_Cursor = ao_Armdb.OpenSQL(ls_Request, -1, 0)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Cap_Common:Init_User", "Request=" & ls_Request
        GoTo Trace_End
    End If
  
    gs_CaptureCountry = ao_Armdb.GetFields(ll_Cursor, "ct_code")
    gs_CaptureLanguage = ao_Armdb.GetFields(ll_Cursor, "spoken_Language")
    
    ao_Armdb.Close ll_Cursor
    
    ls_Request = "exec Cap_DefaultValue_t_lst2 '" & as_UID & "'"
    ll_Cursor = ao_Armdb.OpenSQL(ls_Request, -1, 0)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Cap_Common:Init_User", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    li_DefaultConfigNumber = -1
    
    If ao_Armdb.EOF(ll_Cursor) Then
        ReDim ma_DefaultConfigScreenName(-1 To -1)
        ReDim ma_DefaultConfigFieldName(-1 To -1)
        ReDim ma_DefaultConfigCode(-1 To -1)
        ReDim ma_DefaultConfigDesc(-1 To -1)
    Else
        Do While ao_Armdb.EOF(ll_Cursor) = False
            li_DefaultConfigNumber = li_DefaultConfigNumber + 1
            'MS REDIMM
            Call SafeRedimPreserve(ma_DefaultConfigScreenName, li_DefaultConfigNumber)
            Call SafeRedimPreserve(ma_DefaultConfigFieldName, li_DefaultConfigNumber)
            Call SafeRedimPreserve(ma_DefaultConfigCode, li_DefaultConfigNumber)
            Call SafeRedimPreserve(ma_DefaultConfigDesc, li_DefaultConfigNumber)
            'ReDim Preserve ma_DefaultConfigScreenName(li_DefaultConfigNumber)
            'ReDim Preserve ma_DefaultConfigFieldName(li_DefaultConfigNumber)
            'ReDim Preserve ma_DefaultConfigCode(li_DefaultConfigNumber)
            'ReDim Preserve ma_DefaultConfigDesc(li_DefaultConfigNumber)
            ma_DefaultConfigScreenName(li_DefaultConfigNumber) = ao_Armdb.GetFields(ll_Cursor, "DFT_ScreenName")
            ma_DefaultConfigFieldName(li_DefaultConfigNumber) = ao_Armdb.GetFields(ll_Cursor, "DFT_FieldName")
            ma_DefaultConfigCode(li_DefaultConfigNumber) = ao_Armdb.GetFields(ll_Cursor, "DFT_code")
            ma_DefaultConfigDesc(li_DefaultConfigNumber) = ao_Armdb.GetFields(ll_Cursor, "DFT_desc")
            ao_Armdb.Next ll_Cursor
        Loop
    End If
    
    gl_LocalID = Val(GetDefaultConfigCode("Capture_Cfg", "LocalID"))
    
Trace_End:
    ao_Armdb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:Init_User"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    ao_Armdb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:Init_User"
    CapMouseOn
    Resume
End Sub

Public Sub ReinitTreeViewAfterDelete(ao_grid As ArmGrid, ao_TreeView As ArmTreeView)
Dim lo_Node As Node
Dim lo_NodeParent As Node
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:ReinitTreeViewAfterDelete"
    #End If
    
    ao_grid.DeleteLine
    If ao_grid.Rows = 0 Then
        Set lo_Node = ao_TreeView.SelectedItem
        Set lo_NodeParent = ao_TreeView.SelectedItem.Parent
        ao_TreeView.RemoveNode lo_Node
        If Not lo_NodeParent Is Nothing Then
            Do While lo_NodeParent.children = 0
                Set lo_Node = lo_NodeParent
                Set lo_NodeParent = lo_Node.Parent
                ao_TreeView.RemoveNode lo_Node
                If lo_NodeParent Is Nothing Then Exit Do
            Loop
        End If
        Set ao_TreeView.SelectedItem = Nothing
    End If
            
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:ReinitTreeViewAfterDelete"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:ReinitTreeViewAfterDelete"
    CapMouseOn
End Sub

Public Function IsDefaultPrinterInstalled() As Boolean
Dim ls_Buffer As String
Dim ll_BufSize As Long

On Error GoTo ErrorHandler
  ll_BufSize = 1024
  ls_Buffer = SPACE$(ll_BufSize)
  
  If GetDefaultPrinter(ls_Buffer, ll_BufSize) Then
     ' Truncate at first NULL
     ls_Buffer = Left$(ls_Buffer, InStr(ls_Buffer, vbNullChar) - 1)
     IsDefaultPrinterInstalled = Trim(ls_Buffer) <> ""
  Else
    IsDefaultPrinterInstalled = False
  End If
  Exit Function
ErrorHandler:
  IsDefaultPrinterInstalled = False
End Function


Public Sub Report(ByRef ao_Armdb As Object, ByRef ab_use_framework_connection As Boolean, ByVal as_ConnectString As String, ByVal as_Language_code As String, ByRef ao_grid As ArmGrid, ByVal aet_DataType As DataTypeEnum)
Dim ao_ReportForm As ReportForm
Dim lf_prnChoice As prnChoice

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:Report", "ab_use_framework_connection=" & ab_use_framework_connection, "as_ConnectString=" & as_ConnectString, "as_Language_code=" & as_Language_code, "aet_DataType=" & aet_DataType
    #End If
    CapMouseOff

    If Not IsDefaultPrinterInstalled Then
      Call ASC_SendMessage(ao_Armdb, as_Language_code, 666, "You don't have default printer installed.")
      GoTo Trace_End
    End If
    
    Set lf_prnChoice = New prnChoice
    Load lf_prnChoice
    Set lf_prnChoice.ArmDb = ao_Armdb
    
    lf_prnChoice.Language = as_Language_code
    lf_prnChoice.ConnectString = as_ConnectString
    lf_prnChoice.ComponentType = aet_DataType
    
    Call lf_prnChoice.Load_A_COM
    
    If Not lf_prnChoice.Execute Then
        Call lf_prnChoice.Unload_A_COM
        Unload lf_prnChoice
        Set lf_prnChoice = Nothing
        GoTo Trace_End
    End If
    
    Set ao_ReportForm = New ReportForm
    Load ao_ReportForm
    ao_ReportForm.ConnectString = as_ConnectString
    If ab_use_framework_connection = True Then
        Set ao_ReportForm.ArmDb = ao_Armdb
    End If
    ao_ReportForm.Language = lf_prnChoice.SelectedLanguage
    ao_ReportForm.Load_A_COM
    ao_ReportForm.Key = ao_grid.MultiSelectedKey
    ao_ReportForm.DataChoice = lf_prnChoice.DataChoice
    ao_ReportForm.DataType = aet_DataType

    CapMouseOn True
    Call ao_ReportForm.show(vbModal)
    CapMouseOff True
    
    ao_ReportForm.Unload_A_COM
    Unload ao_ReportForm
    Set ao_ReportForm = Nothing
    Call lf_prnChoice.Unload_A_COM
    Unload lf_prnChoice
    Set lf_prnChoice = Nothing

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:Report"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not ao_ReportForm Is Nothing Then
        Call ao_ReportForm.Unload_A_COM
        Unload ao_ReportForm
    End If
    Set ao_ReportForm = Nothing
    
    If Not lf_prnChoice Is Nothing Then
        Call lf_prnChoice.Unload_A_COM
        Unload lf_prnChoice
    End If
    Set lf_prnChoice = Nothing
    
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:Report"
    CapMouseOn True
End Sub

Public Sub LoadListView(ByRef ao_Armdb As Object, ByRef ao_List As ListView, as_Request As String, Optional ab_CheckBox As Boolean = False, Optional al_CheckField As Long = -1)
Dim ll_Cursor As Long
Dim lo_Line As ListItem
Dim i As Integer
Dim j As Integer
Dim li_rowCount As Integer
Dim li_ColCount As Integer
Dim TheValue As Variant
Dim la_DataRow As Variant
Dim la_Fields As Variant
Dim CheckValue As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:LoadListView", "as_Request=" & as_Request, "ab_CheckBox=" & ab_CheckBox, "al_CheckField=" & al_CheckField
    #End If
    
    'On purge la liste
    ao_List.ListItems.Clear

    'TODO: test si la connexion a deja ete realisee
    
    ll_Cursor = ao_Armdb.OpenSQL(as_Request, -1, 0)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Cap_Common:LoadListView", "Request=" & as_Request
        GoTo Trace_End
    End If
    
    li_rowCount = ao_Armdb.RowCount(ll_Cursor)
    If li_rowCount = 0 Then GoTo Trace_End
    
    li_ColCount = ao_Armdb.FieldCount(ll_Cursor) - 1
    la_Fields = ao_Armdb.la_Fields(ll_Cursor)    'get field names

    'Entte
    ao_List.ColumnHeaders.Clear
    'ao_List.ColumnHeaders.Add 1, , la_Fields(i), 800
    For i = 0 To li_ColCount
        ao_List.ColumnHeaders.Add i + 1, , la_Fields(i), 800
    Next i
   
    ao_List.AllowColumnReorder = False

    'Remplissage
    For i = 0 To li_rowCount - 1
        
        la_DataRow = ao_Armdb.GetRowAt(ll_Cursor, i)       'read row
        
        Set lo_Line = ao_List.ListItems.Add(, , "")
    
        If al_CheckField <> -1 Then
            CheckValue = la_DataRow(al_CheckField)
            If CheckValue = "" Then
                lo_Line.Checked = False
            Else
                lo_Line.Checked = True
            End If
        End If
       
        lo_Line.ListSubItems.Clear
        For j = 0 To li_ColCount
            lo_Line.ListSubItems.Add
            lo_Line.ListSubItems(lo_Line.ListSubItems.Count).Text = la_DataRow(j)
        Next j

    Next i
    
    ao_List.View = lvwReport

    ao_List.Checkboxes = ab_CheckBox
    ao_List.Refresh
    
Trace_End:
    ao_Armdb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:LoadListView"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    ao_Armdb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:LoadListView"
    CapMouseOn
End Sub

Function RepositionAfterSeek(ASearchString As String, ATreeView As ArmTreeView) As String
Dim TheKeyValue As String
Dim Values As Variant
Dim ObjectCount As Variant
Dim TheValue As String
Dim Pos As Integer
Dim i As Long
Dim AllFound As Integer

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:RepositionAfterSeek", "ASearchString=" & ASearchString
    #End If
    
    If Trim$(ASearchString) = "" Then GoTo Trace_End
    
    Values = Split(ASearchString, CH_LDELIMIT)
    ObjectCount = UBound(Values) + 1

    AllFound = 0
    TheKeyValue = Values(0)

    For i = 1 To ObjectCount - 1
        TheValue = Values(i)
        'Now, find in TreeView
        If TheValue <> "" Then
            If i = 1 Then
            If ATreeView.Find(TheValue, 2, , i - 1) Then
                ATreeView.ExpandNode ATreeView.SelectedItem
                AllFound = AllFound + 1
            End If
            
            Else
                If ATreeView.Find(TheValue, 2, ATreeView.SelectedItem, i - 1) Then
                    ATreeView.ExpandNode ATreeView.SelectedItem
                    AllFound = AllFound + 1
        End If
            End If
        End If
    Next i
    
    If AllFound = ObjectCount - 1 Then
        RepositionAfterSeek = TheKeyValue
    Else
        RepositionAfterSeek = ""
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:RepositionAfterSeek", "Result=" & RepositionAfterSeek
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:RepositionAfterSeek"
    CapMouseOn
End Function

Public Sub VerifyInitialization(ao_Armdb As Object, as_ConnectString As String, as_Language As String, ao_Object As Object)

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:VerifyInitialization"
    #End If
    
    #If CapDebug Then
        If ao_Armdb Is Nothing Then
            MsgBox "Armdb non initialis pour " & TypeName(ao_Object)
        End If
        If as_ConnectString = "" Then
            MsgBox "ConnectString non initialis pour " & TypeName(ao_Object)
        End If
    #End If
    If as_Language = "" Then
        #If CapDebug Then
            MsgBox "Langage non initialis pour " & TypeName(ao_Object)
            ao_Object.Language = "E"
    #End If
    End If
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:VerifyInitialization"
    #End If
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:VerifyInitialization"
    
End Sub

Public Function GetDefaultConfigCode(ByVal as_ScreenName As String, ByVal as_FieldName As String) As String
Dim i As Integer
Dim li_Count As Integer

    'li_Count = 0
    'On Error Resume Next
    li_Count = UBound(ma_DefaultConfigCode)

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:GetDefaultConfigCode", "as_ScreenName=" & as_ScreenName, "as_FieldName=" & as_FieldName
    #End If
    
    GetDefaultConfigCode = ""
    
    For i = 0 To li_Count
        If StrComp(ma_DefaultConfigScreenName(i), as_ScreenName, vbTextCompare) = 0 And StrComp(ma_DefaultConfigFieldName(i), as_FieldName, vbTextCompare) = 0 Then
            GetDefaultConfigCode = ma_DefaultConfigCode(i)
            Exit For
        End If
    Next
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:GetDefaultConfigCode", "Result=" & GetDefaultConfigCode
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:GetDefaultConfigCode"
    CapMouseOn
End Function

Public Function GetDefaultConfigDesc(ByVal as_ScreenName As String, ByVal as_FieldName As String) As String
Dim i As Integer
Dim li_Count As Integer

    li_Count = 0
    On Error Resume Next
    li_Count = UBound(ma_DefaultConfigCode)

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:GetDefaultConfigDesc", "as_ScreenName=" & as_ScreenName, "as_FieldName=" & as_FieldName
    #End If
    
    GetDefaultConfigDesc = ""
    
    For i = 0 To li_Count
        If StrComp(ma_DefaultConfigScreenName(i), as_ScreenName, vbTextCompare) = 0 And StrComp(ma_DefaultConfigFieldName(i), as_FieldName, vbTextCompare) = 0 Then
            GetDefaultConfigDesc = ma_DefaultConfigDesc(i)
            Exit For
        End If
    Next
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:GetDefaultConfigDesc", "Result=" & GetDefaultConfigDesc
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:GetDefaultConfigDesc"
    CapMouseOn
End Function

Public Function Add_ProjectRep(ByRef ao_Armdb As Object, ByVal as_SP_Capkey As String, ByVal as_SR_Code As String, ByVal as_RR_Code As String, ByRef as_Result As String) As Boolean

Dim ls_Request As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:Add_ProjectRep", "as_SP_CapKey=" & as_SP_Capkey, "as_SR_Code=" & as_SR_Code
    #End If
    CapMouseOff

    Add_ProjectRep = False

    ls_Request = "exec Cap_ProjectRep_Ins " & FormatSqlStringParameter(as_SP_Capkey) & "," & FormatSqlStringParameter(as_SR_Code) & "," & FormatSqlStringParameter(as_RR_Code) & ",'Y','N', NULL , '','',0,0"
    
    Add_ProjectRep = ASC_RecordExec(ao_Armdb, ls_Request, as_Result)
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:Add_ProjectRep", "Result=" & Add_ProjectRep, "as_Result=" & as_Result
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:Add_ProjectRep"
    CapMouseOn
End Function

Public Function GetStringPart(ByVal as_str As String) As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:GetStringPart", "as_Str=" & as_str
    #End If
    CapMouseOff
    
    Dim ls_NumPart As String, ls_StrPart As String
    
    ls_NumPart = Val("1" + StrReverse(as_str))
    ls_StrPart = Left(as_str, Len(as_str) - Len(ls_NumPart) + 1)
    
    GetStringPart = ls_StrPart
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:GetStringPart", "Result=" & GetStringPart
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    GetStringPart = ""
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:GetStringPart"
    CapMouseOn
End Function

Public Function GetNumericPart(ByVal as_str As String) As String
Dim ll_Part As Long
Dim ls_Reverse As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:GetNumericPart", "as_Str=" & as_str
    #End If
    CapMouseOff
    
    ls_Reverse = Val("1" + StrReverse(as_str))
    If ls_Reverse = "1" Then
        ll_Part = -1
    Else
        ll_Part = Val(StrReverse(right(ls_Reverse, Len(ls_Reverse) - 1)))
    End If
    GetNumericPart = ll_Part
        
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:GetNumericPart", "Result=" & GetNumericPart
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    GetNumericPart = -1
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:GetNumericPart"
    CapMouseOn
End Function

Public Sub ExportExcel(ByRef ao_Armdb As Object, ByRef ab_use_framework_connection As Boolean, ByVal as_ConnectString As String, ByVal as_Language_code As String, ByRef ao_grid As ArmGrid, ByVal aet_DataType As DataTypeEnum)
Dim ao_ExportExcelForm As ExportExcelForm
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:ExportExcel", "ab_use_framework_connection=" & ab_use_framework_connection, "as_ConnectString=" & as_ConnectString, "as_Language_code=" & as_Language_code, "aet_DataType=" & aet_DataType
    #End If
    CapMouseOff

    Set ao_ExportExcelForm = New ExportExcelForm
    Load ao_ExportExcelForm
    ao_ExportExcelForm.ConnectString = as_ConnectString
    If ab_use_framework_connection = True Then
        Set ao_ExportExcelForm.ArmDb = ao_Armdb
    End If
    ao_ExportExcelForm.Language = as_Language_code
    ao_ExportExcelForm.Load_A_COM
    Set ao_ExportExcelForm.Grid = ao_grid
    ao_ExportExcelForm.DataType = aet_DataType
    CapMouseOn True
    Call ao_ExportExcelForm.show(vbModal)
    CapMouseOff True
    ao_ExportExcelForm.Unload_A_COM
    Unload ao_ExportExcelForm
    Set ao_ExportExcelForm = Nothing
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:ExportExcel"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:ExportExcel"
    CapMouseOn
End Sub

Public Function SetLstKey(ByVal as_Key As String)
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:SetLstKey", "as_Key=" & as_Key
    #End If
    
    SetLstKey = CH_LDELIMIT & as_Key
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:SetLstKey", "Result=" & SetLstKey
    #End If
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:SetLstKey"
    
End Function

Public Function GetLstKey(ByVal as_Key As String)
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Cap_Common:GetLstKey", "as_Key=" & as_Key
    #End If
    
    GetLstKey = right(as_Key, Len(as_Key) - Len(CH_LDELIMIT))
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Cap_Common:GetLstKey", "Result=" & GetLstKey
    #End If
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Common:SetGetKey"

End Function

